Ext.data.JsonP.sol_common_forms_FormWrapper_Field({"tagname":"class","name":"sol.common.forms.FormWrapper.Field","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.forms.FormWrapper.js","href":"lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field"}],"author":[{"tagname":"author","name":"ESt, ELO Digital Office GmbH","email":null}],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"","tagname":"property","owner":"sol.common.forms.FormWrapper.Field","id":"property-","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addKeyToEloVerify","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-addKeyToEloVerify","meta":{"private":true}},{"name":"applyStandardManipulator","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-applyStandardManipulator","meta":{"private":true}},{"name":"changeVisibility","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-changeVisibility","meta":{"private":true}},{"name":"convertToDiv","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-convertToDiv","meta":{"private":true}},{"name":"element","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-element","meta":{}},{"name":"get","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-get","meta":{}},{"name":"getDynKwlName","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-getDynKwlName","meta":{}},{"name":"getSelectedLocalizedDynKwlKey","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-getSelectedLocalizedDynKwlKey","meta":{"private":true}},{"name":"getSelectedLocalizedDynKwlString","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-getSelectedLocalizedDynKwlString","meta":{"private":true}},{"name":"getSelectedLocalizedDynKwlValue","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-getSelectedLocalizedDynKwlValue","meta":{"private":true}},{"name":"hide","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-hide","meta":{}},{"name":"initRedactor","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-initRedactor","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-initialize","meta":{"private":true}},{"name":"isEditor","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-isEditor","meta":{"private":true}},{"name":"kwlStyle","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-kwlStyle","meta":{"private":true}},{"name":"makeMandatory","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-makeMandatory","meta":{"private":true}},{"name":"makeOptional","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-makeOptional","meta":{"private":true}},{"name":"modifyEloVerify","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-modifyEloVerify","meta":{"private":true}},{"name":"removeKeyFromEloVerify","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-removeKeyFromEloVerify","meta":{"private":true}},{"name":"selectDynKwlEntry","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-selectDynKwlEntry","meta":{"private":true}},{"name":"set","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-set","meta":{}},{"name":"setAttribute","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-setAttribute","meta":{"private":true}},{"name":"setImage","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-setImage","meta":{}},{"name":"setImageUrl","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-setImageUrl","meta":{}},{"name":"setLocalizedDynKwlKey","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-setLocalizedDynKwlKey","meta":{"private":true}},{"name":"setPlaceholder","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-setPlaceholder","meta":{}},{"name":"setStyleAttribute","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-setStyleAttribute","meta":{}},{"name":"show","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-show","meta":{}},{"name":"tooltip","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-tooltip","meta":{}},{"name":"value","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-value","meta":{}},{"name":"valueFromEloParams","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-valueFromEloParams","meta":{"private":true}},{"name":"writeTooltip","tagname":"method","owner":"sol.common.forms.FormWrapper.Field","id":"method-writeTooltip","meta":{}}],"code_type":"ext_define","id":"class-sol.common.forms.FormWrapper.Field","short_doc":"Represents a form-template's field. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.forms.FormWrapper.Field</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field' target='_blank'>lib_sol.common.forms.FormWrapper.js</a></div></pre><div class='doc-contents'><p>Represents a form-template's field.</p>\n\n<p>Fields are automatically linked to their label, if they are called</p>\n\n<pre><code>\"LBL_\" + me.prefix + me.getShortName();\n</code></pre>\n\n<p>To make things easier, localizedKwls will automatically be linked to\na selector:</p>\n\n<pre><code>me.fName + \"_UNIT\"\n</code></pre>\n\n<p>e.g.</p>\n\n<pre><code>IX_MAP_HR_PERSONNEL_DEPARTMENT\nlabel: LBL_HR_PERSONNEL_DEPARTMENT\nselector: IX_MAP_HR_PERSONNEL_DEPARTMENT_UNIT\n</code></pre>\n\n<p>This is important for the ´smart´ \"set\" and \"value\" functions to work!</p>\n\n<p>Setting a localizedKwl Value the old way:</p>\n\n<pre><code>//insert complicated, localizedKwl specific code here\n</code></pre>\n\n<p>Setting a localizedKwl Value the new way:</p>\n\n<pre><code>form.fields.IX_MAP_HR_PERSONNEL_DEPARTMENT.set(\"DEV\")\n</code></pre>\n\n<p>The same also works for dates and of course \"normal fields\".</p>\n\n<p>field.show() and field.hide() take two parameters:\nincludingLabel     Boolean\nincludingSelector  Boolean\nIf both parameters are set to true, the field, its label and its unit-selector will be hidden/shown.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-property-' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-property-' class='name expandable'></a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>In case of an error, the placeholder should reset to avoid inconsistent state</p>\n</div><div class='long'><p>In case of an error, the placeholder should reset to avoid inconsistent state</p>\n</div></div></div><div id='property-S-className' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addKeyToEloVerify' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-addKeyToEloVerify' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-addKeyToEloVerify' class='name expandable'>addKeyToEloVerify</a>( <span class='pre'>eloVerify</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eloVerify</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-applyStandardManipulator' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-applyStandardManipulator' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-applyStandardManipulator' class='name expandable'>applyStandardManipulator</a>( <span class='pre'>manipulator, includingLabel, includingSelector</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>applies a manipulator function to the field ...</div><div class='long'><p>applies a manipulator function to the field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>manipulator</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>includingLabel</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>includingSelector</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-changeVisibility' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-changeVisibility' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-changeVisibility' class='name expandable'>changeVisibility</a>( <span class='pre'>visible, includingLabel, includingSelector</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>please use show() or hide() for the same effect ...</div><div class='long'><p>please use show() or hide() for the same effect</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>visible</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>includingLabel</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>includingSelector</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-convertToDiv' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-convertToDiv' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-convertToDiv' class='name expandable'>convertToDiv</a>( <span class='pre'>url</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-element' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-element' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-element' class='name expandable'>element</a>( <span class='pre'></span> ) : HTML-DIV<span class=\"signature\"></span></div><div class='description'><div class='short'>wrapper around $var, can also work with images (which $var can't) ...</div><div class='long'><p>wrapper around $var, can also work with images (which $var can't)</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTML-DIV</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-get' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-get' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-get' class='name expandable'>get</a>( <span class='pre'>content</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>content</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getDynKwlName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-getDynKwlName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-getDynKwlName' class='name expandable'>getDynKwlName</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>determines the dynamic keyword list's name, if the field is linked to one and returns it ...</div><div class='long'><p>determines the dynamic keyword list's name, if the field is linked to one and returns it</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSelectedLocalizedDynKwlKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-getSelectedLocalizedDynKwlKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-getSelectedLocalizedDynKwlKey' class='name expandable'>getSelectedLocalizedDynKwlKey</a>( <span class='pre'>key</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>please use getSelectedLocalizedDynKwlValue() without a parameter for the same effect ...</div><div class='long'><p>please use getSelectedLocalizedDynKwlValue() without a parameter for the same effect</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getSelectedLocalizedDynKwlString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-getSelectedLocalizedDynKwlString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-getSelectedLocalizedDynKwlString' class='name expandable'>getSelectedLocalizedDynKwlString</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>please use getSelectedLocalizedDynKwlValue() with { localizedStringOnly:true } for the same effect ...</div><div class='long'><p>please use getSelectedLocalizedDynKwlValue() with { localizedStringOnly:true } for the same effect</p>\n</div></div></div><div id='method-getSelectedLocalizedDynKwlValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-getSelectedLocalizedDynKwlValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-getSelectedLocalizedDynKwlValue' class='name expandable'>getSelectedLocalizedDynKwlValue</a>( <span class='pre'>opts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>please use value() for the same effect ...</div><div class='long'><p>please use value() for the same effect</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>opts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-hide' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-hide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-hide' class='name expandable'>hide</a>( <span class='pre'>includingLabel, includingSelector</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>hides the field on the form ...</div><div class='long'><p>hides the field on the form</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>includingLabel</span> : Boolean<div class='sub-desc'><p>also hides the field's label</p>\n</div></li><li><span class='pre'>includingSelector</span> : Boolean<div class='sub-desc'><p>also hides the field's selector</p>\n</div></li></ul></div></div></div><div id='method-initRedactor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-initRedactor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-initRedactor' class='name expandable'>initRedactor</a>( <span class='pre'>options</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-isEditor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-isEditor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-isEditor' class='name expandable'>isEditor</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-kwlStyle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-kwlStyle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-kwlStyle' class='name expandable'>kwlStyle</a>( <span class='pre'>mode</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>removes selector from a kwl-field (e.g. ...</div><div class='long'><p>removes selector from a kwl-field (e.g. for making it readonly)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mode</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-makeMandatory' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-makeMandatory' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-makeMandatory' class='name expandable'>makeMandatory</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>please use setAttribute(\"optional\", false) ...</div><div class='long'><p>please use setAttribute(\"optional\", false)</p>\n</div></div></div><div id='method-makeOptional' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-makeOptional' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-makeOptional' class='name expandable'>makeOptional</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>please use setAttribute(\"optional\", true) ...</div><div class='long'><p>please use setAttribute(\"optional\", true)</p>\n</div></div></div><div id='method-modifyEloVerify' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-modifyEloVerify' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-modifyEloVerify' class='name expandable'>modifyEloVerify</a>( <span class='pre'>element, action</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>used by assignValidationFunctionToWindow ...</div><div class='long'><p>used by assignValidationFunctionToWindow</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>action</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-removeKeyFromEloVerify' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-removeKeyFromEloVerify' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-removeKeyFromEloVerify' class='name expandable'>removeKeyFromEloVerify</a>( <span class='pre'>eloVerify</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eloVerify</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-selectDynKwlEntry' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-selectDynKwlEntry' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-selectDynKwlEntry' class='name expandable'>selectDynKwlEntry</a>( <span class='pre'>value</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-set' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-set' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-set' class='name expandable'>set</a>( <span class='pre'>content</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>content</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-setAttribute' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-setAttribute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-setAttribute' class='name expandable'>setAttribute</a>( <span class='pre'>attribute, value</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>used by FormWrapper to map state properties to the respective functions ...</div><div class='long'><p>used by FormWrapper to map state properties to the respective functions</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>attribute</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>value</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-setImage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-setImage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-setImage' class='name expandable'>setImage</a>( <span class='pre'>guid</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>sets an Image divs Image to the image having the passed guid. ...</div><div class='long'><p>sets an Image divs Image to the image having the passed guid. If no guid is passed, and the field's value contains a guid, it will be used instead</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>guid</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setImageUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-setImageUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-setImageUrl' class='name expandable'>setImageUrl</a>( <span class='pre'>url</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets an image by an URL ...</div><div class='long'><p>Sets an image by an URL</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : String<div class='sub-desc'><p>URL</p>\n</div></li></ul></div></div></div><div id='method-setLocalizedDynKwlKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-setLocalizedDynKwlKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-setLocalizedDynKwlKey' class='name expandable'>setLocalizedDynKwlKey</a>( <span class='pre'>key</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>please use set() for the same effect ...</div><div class='long'><p>please use set() for the same effect</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setPlaceholder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-setPlaceholder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-setPlaceholder' class='name expandable'>setPlaceholder</a>( <span class='pre'>placeholderValue</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Write a placeholder to the current field element ...</div><div class='long'><p>Write a placeholder to the current field element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>placeholderValue</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-setStyleAttribute' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-setStyleAttribute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-setStyleAttribute' class='name expandable'>setStyleAttribute</a>( <span class='pre'>attribute, value, includingLabel, includingSelector</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>can be used to set an HTML Attribute ...</div><div class='long'><p>can be used to set an HTML Attribute</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>attribute</span> : String<div class='sub-desc'><p>name of the style attribute</p>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'><p>value for the attribute</p>\n</div></li><li><span class='pre'>includingLabel</span> : Boolean<div class='sub-desc'><p>also set attribute for field's label</p>\n</div></li><li><span class='pre'>includingSelector</span> : Boolean<div class='sub-desc'><p>also set attribute for field's selector</p>\n</div></li></ul></div></div></div><div id='method-show' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-show' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-show' class='name expandable'>show</a>( <span class='pre'>includingLabel, includingSelector</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>unhides/shows the field on the form ...</div><div class='long'><p>unhides/shows the field on the form</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>includingLabel</span> : Boolean<div class='sub-desc'><p>also unhide/show the field's label</p>\n</div></li><li><span class='pre'>includingSelector</span> : Boolean<div class='sub-desc'><p>also unhide/show the field's selector</p>\n</div></li></ul></div></div></div><div id='method-tooltip' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-tooltip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-tooltip' class='name expandable'>tooltip</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>returns current tooltip as a String ...</div><div class='long'><p>returns current tooltip as a String</p>\n</div></div></div><div id='method-value' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-value' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-value' class='name expandable'>value</a>( <span class='pre'>opts</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>determines the field's value. ...</div><div class='long'><p>determines the field's value.</p>\n\n<p>returns an isoDate if the field is a date.\nreturns its key, if the field is a localizedKwl.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>opts</span> : Object<div class='sub-desc'></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-valueFromEloParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-valueFromEloParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-valueFromEloParams' class='name expandable'>valueFromEloParams</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-writeTooltip' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Field'>sol.common.forms.FormWrapper.Field</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Field-method-writeTooltip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Field-method-writeTooltip' class='name expandable'>writeTooltip</a>( <span class='pre'>tip</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>writes tip as the new tooltip ...</div><div class='long'><p>writes tip as the new tooltip</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tip</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div></div></div></div>","meta":{}});